set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8115606';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-11-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3204',
      '20014204',
      NULL,
      62.576458,
      '0123123',
      120,
      1,
      3.728203,
      0,
      '144312',
      NULL,
      ' 3-26-1976',
      181.203650,
      23.768919,
      1.069078,
      NULL,
      1.118865,
      0.377369,
      0.663638,
      0.248890,
      NULL,
      0,
      0.373790,
      1.704238,
      0.919636,
      0.274889,
      4.347152,
      0,
      1.971654,
      5,
      NULL,
      0.825315,
      6,
      0,
      0,
      0.838723,
      1.002528,
      1,
      3,
      0,
      4.522333,
      NULL,
      2.588470,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      11.009926,
      0,
      NULL,
      1.330375,
      NULL,
      1,
      0.665837,
      0.643908,
      3,
      1.046958,
      0,
      1,
      0.856389,
      0,
      2.889513,
      NULL,
      0.581761,
      0.902998,
      2.068171,
      0.504359,
      0,
      0.601901,
      NULL,
      1,
      0,
      0,
      1.211998,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.216765,
      1,
      0,
      NULL,
      NULL,
      1.991755,
      0.372371,
      1.174104,
      0.626300,
      1,
      0,
      0,
      NULL,
      0,
      0,
      1.271964,
      0.368784,
      0.259475,
      NULL,
      NULL,
      NULL,
      6.462588,
      0.108879,
      0.062095,
      3.042346,
      NULL,
      2,
      NULL,
      7,
      7,
      5,
      1.913457,
      0.354793,
      6,
      NULL,
      NULL,
      2.937687,
      2.408102,
      4.296743,
      5.637617,
      4,
      NULL,
      1,
      1.152776,
      1.518280,
      NULL,
      0.520652,
      1,
      NULL,
      NULL,
      NULL,
      0.925607,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.706194,
      1,
      1,
      NULL,
      0.648452,
      0,
      0.183958,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.372240,
      2.056868,
      0.744240,
      1.233325,
      4,
      5.533268,
      0,
      0.656717,
      NULL,
      NULL,
      NULL,
      0.152994,
      0.912813,
      1.285061,
      3,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.391806,
      7.848096,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.910093,
      1.063376,
      NULL,
      0.213206,
      3.614091,
      NULL,
      3,
      0,
      NULL,
      0,
      1.328888,
      1,
      1,
      0.693054,
      0,
      1.303667,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.591889,
      1.307947,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.376634,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.531751,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.215632,
      1.539858,
      NULL,
      NULL,
      1.565506,
      1.136197,
      0.170747,
      1,
      3,
      '31244',
      '',
      '',
      1.153468,
      '',
      '',
      '',
      7,
      '34413',
      '3012',
      NULL,
      5,
      3,
      2.967737,
      0,
      1,
      1.718755,
      0,
      1,
      1);
commit;
end;
/


