set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8115606';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-5-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1130',
      '01211204',
      16,
      53.060282,
      '1224321',
      83,
      0,
      2.165362,
      3,
      '131042',
      3,
      ' 4- 5-1983',
      70,
      12,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.913649,
      1.957270,
      1,
      3.961810,
      2,
      1,
      0.732571,
      NULL,
      1.752770,
      0,
      2.794980,
      1.774359,
      0.349841,
      5,
      0.722109,
      0,
      1.510010,
      1,
      1,
      NULL,
      1,
      1.875000,
      NULL,
      3.823525,
      1.447434,
      NULL,
      NULL,
      1.690504,
      NULL,
      NULL,
      9.057682,
      4,
      0.838276,
      0.136298,
      0.625032,
      NULL,
      NULL,
      1,
      0.045855,
      1.428652,
      1.706843,
      NULL,
      0.146380,
      0.500287,
      1,
      0.807752,
      1,
      NULL,
      NULL,
      1.895178,
      0.513247,
      1.775859,
      9,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.722503,
      NULL,
      NULL,
      NULL,
      1,
      0.486457,
      0,
      1,
      1.006186,
      0.399992,
      0,
      1.271883,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      0.065384,
      NULL,
      0.661979,
      NULL,
      0,
      6,
      0.405181,
      2,
      1.534603,
      0,
      3,
      0.248305,
      2,
      4,
      6.454933,
      4.367528,
      1,
      9,
      8,
      0.604901,
      NULL,
      7,
      1.641400,
      1,
      8,
      NULL,
      1,
      9,
      1.070825,
      1.828271,
      NULL,
      1,
      0,
      1.435490,
      0.928357,
      3.820987,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      0.521886,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      1,
      1,
      NULL,
      0.796157,
      2.981014,
      3,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.403688,
      NULL,
      9.581425,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      3.543655,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0.079944,
      NULL,
      1.590805,
      NULL,
      1,
      NULL,
      1,
      NULL,
      2,
      0.020069,
      0.979161,
      NULL,
      0.209324,
      NULL,
      0.973100,
      1.417495,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.786382,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.767164,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.505267,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      0.061983,
      '03324',
      '',
      '',
      1,
      '',
      '',
      '',
      6.032714,
      '12234',
      '2422',
      '0312',
      2,
      0.380033,
      3,
      3.392250,
      3,
      1.755645,
      0.069409,
      0,
      1);
commit;
end;
/


