set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9411501';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0324143',
      2,
      2,
      22.994299,
      NULL,
      1.219060,
      NULL,
      NULL,
      NULL,
      0.055844,
      1.332728,
      1.060943,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.038751,
      0,
      1,
      1,
      3.191369,
      1,
      NULL,
      0.959845,
      2.320543,
      0,
      1.795967,
      1,
      2,
      0.493444,
      0.681039,
      0,
      0,
      0.706875,
      2,
      NULL,
      NULL,
      1,
      NULL,
      0.549782,
      3.957616,
      2,
      0,
      1.568808,
      0,
      1,
      0,
      NULL,
      2.565186,
      1,
      1.229777,
      1.521518,
      NULL,
      1.208897,
      0,
      0,
      1,
      0.456763,
      1.817938,
      1.154036,
      1.554792,
      NULL,
      1,
      0,
      3.729687,
      1,
      2.627361,
      1.040196,
      0,
      NULL,
      NULL,
      0,
      1.188305,
      NULL,
      1,
      NULL,
      1,
      0,
      1.440988,
      NULL,
      1.493086,
      1.013341,
      0,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      2.047132,
      0.837740,
      1,
      0.311927,
      1.685511,
      0.523314,
      2.766391,
      1,
      1.840007,
      2,
      NULL,
      1,
      0.225675,
      1,
      17.965857,
      1,
      '310',
      '21',
      ' 1- 3-2002');
commit;
end;
/


