set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8720709';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2401134',
      2.996689,
      3,
      2,
      1,
      NULL,
      NULL,
      NULL,
      23.204322,
      0.895555,
      2,
      0,
      0.437321,
      3,
      1,
      2,
      2,
      NULL,
      1,
      3.444749,
      0,
      0,
      2,
      1.631395,
      0.122426,
      0,
      3,
      1.224469,
      1.516988,
      0.028172,
      2,
      0,
      0.411321,
      1.500665,
      0,
      1,
      0.263203,
      0,
      NULL,
      0.124178,
      0.925447,
      1,
      NULL,
      1.261380,
      1.786904,
      1,
      1.379497,
      1,
      0,
      NULL,
      3.116150,
      NULL,
      NULL,
      0.080075,
      NULL,
      0.548935,
      1.109707,
      1,
      1.247882,
      2,
      1,
      1.152132,
      1,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      1,
      1,
      0,
      1.356333,
      0,
      1,
      0,
      2,
      0.612840,
      1.535277,
      1,
      1,
      1,
      1.963311,
      1.937310,
      1,
      NULL,
      1.769499,
      0.825499,
      0,
      1,
      1,
      0.859647,
      2,
      NULL,
      1.023374,
      1,
      1,
      1.348069,
      1,
      2,
      3,
      2.077158,
      2.906695,
      1,
      0,
      NULL,
      4.744434,
      NULL,
      NULL,
      ' 6- 6-1997');
commit;
end;
/


