set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '5607484';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4322021',
      NULL,
      NULL,
      24.227935,
      0,
      1,
      2.122771,
      2.156842,
      18,
      0.924223,
      NULL,
      2,
      0,
      NULL,
      0.598043,
      NULL,
      NULL,
      0.450562,
      1.084477,
      NULL,
      0,
      NULL,
      0,
      0.056970,
      1.809334,
      NULL,
      0.189764,
      0.071212,
      0,
      NULL,
      0.609091,
      0,
      NULL,
      0.475526,
      NULL,
      0,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      3,
      NULL,
      0,
      1.363717,
      1,
      1,
      1,
      0,
      2,
      0,
      1.578916,
      1,
      0.852465,
      0,
      NULL,
      NULL,
      NULL,
      0,
      3.029025,
      0.731547,
      1,
      1.792390,
      1.917117,
      1.420853,
      2,
      0.716256,
      1.415832,
      NULL,
      1.206071,
      0,
      1.181795,
      1,
      0.717918,
      1.459478,
      1,
      0.337906,
      1,
      1.037210,
      1.257737,
      0,
      1,
      1.706443,
      0.327904,
      1,
      0.455868,
      0.977995,
      0,
      NULL,
      0,
      1.919601,
      0,
      2.299434,
      0.806901,
      1.318018,
      NULL,
      NULL,
      0,
      0,
      NULL,
      3.071722,
      0,
      1.653382,
      0,
      7,
      5,
      '',
      '',
      ' 5-11-1982');
commit;
end;
/


