set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8725677';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1111332',
      3.924201,
      2,
      20.753004,
      3.395885,
      0,
      NULL,
      NULL,
      31.458466,
      1.265810,
      1,
      NULL,
      0,
      NULL,
      1,
      0.979261,
      0,
      1.932971,
      0,
      1.114415,
      0.204195,
      1.437563,
      3,
      1,
      0.732649,
      1.394230,
      3.944776,
      0,
      NULL,
      NULL,
      3.485890,
      0,
      1,
      0.818253,
      NULL,
      1.407361,
      NULL,
      1.085182,
      1.905719,
      0,
      0,
      1.102426,
      0,
      3.517411,
      2,
      NULL,
      0.092363,
      0.102795,
      NULL,
      0.030717,
      3,
      1.319703,
      1,
      0.786147,
      0,
      1.724942,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.273026,
      0.224877,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      0,
      0.156706,
      1.398294,
      3,
      1,
      1,
      0.036322,
      0,
      1,
      0.075384,
      1,
      1,
      1,
      1,
      1.246444,
      NULL,
      0,
      1.163378,
      1.997762,
      0.549126,
      NULL,
      1.274053,
      0,
      1,
      2,
      0.470323,
      1.546258,
      3,
      1.831186,
      0,
      2,
      0.075360,
      NULL,
      NULL,
      NULL,
      NULL,
      '431',
      '030',
      NULL);
commit;
end;
/


