set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9023819';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1142424',
      3,
      NULL,
      17.752796,
      0,
      0.944859,
      NULL,
      NULL,
      NULL,
      NULL,
      1.707816,
      0.433851,
      0.205883,
      1.023750,
      NULL,
      0.871878,
      2.230451,
      NULL,
      1,
      0,
      1,
      0,
      NULL,
      0.309398,
      0,
      0.749483,
      1.854569,
      0,
      NULL,
      1.400105,
      2.295472,
      1.960142,
      0,
      0.156296,
      NULL,
      1,
      2,
      0.131505,
      0,
      0.495324,
      0.847943,
      2.635108,
      NULL,
      3,
      NULL,
      NULL,
      0.844883,
      0.376728,
      0.842041,
      0,
      1,
      1.007307,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      0.563337,
      2.315003,
      2.739323,
      1.684158,
      1.279898,
      0.285221,
      0.210275,
      1,
      2.564470,
      1.691115,
      0.462112,
      0.548333,
      1,
      NULL,
      NULL,
      2.315131,
      0.281705,
      NULL,
      3.372582,
      0,
      0,
      1,
      1,
      1,
      0.792241,
      1,
      0,
      1.866248,
      1.509497,
      1,
      0.856045,
      0.585924,
      NULL,
      0,
      3.625857,
      1,
      0,
      0,
      NULL,
      1.450837,
      NULL,
      1.444370,
      1,
      3,
      3.430548,
      1,
      NULL,
      18.712869,
      2.890336,
      NULL,
      '',
      ' 9- 7-1984');
commit;
end;
/


