set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7814692';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      3,
      0,
      15.856813,
      3.586837,
      0.827060,
      NULL,
      NULL,
      39.881412,
      NULL,
      3,
      0.705182,
      2.012916,
      3.575647,
      0.133157,
      1,
      1,
      0,
      1,
      NULL,
      1,
      2.354401,
      1,
      1.819381,
      0,
      1.288308,
      NULL,
      2.456301,
      1.544006,
      1,
      2,
      0,
      1,
      0.143173,
      0,
      NULL,
      1,
      0.801133,
      0.880589,
      0,
      NULL,
      1,
      3,
      1,
      1,
      NULL,
      3.366605,
      1,
      2,
      NULL,
      2,
      1,
      0,
      0,
      NULL,
      1,
      0.034222,
      1.793831,
      0,
      2,
      2,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.503722,
      NULL,
      1.925637,
      0.786863,
      0.009760,
      1.123252,
      0,
      NULL,
      0,
      0,
      1.738076,
      0,
      1.893754,
      NULL,
      0,
      0.405690,
      1.421767,
      1,
      NULL,
      1.284107,
      1.044749,
      0,
      NULL,
      0.860947,
      0.316010,
      0.328366,
      2,
      0,
      NULL,
      1.908948,
      2,
      1.506087,
      2.452435,
      1.364416,
      2.785310,
      NULL,
      1.728053,
      0.858115,
      1.878171,
      12.668517,
      '',
      '',
      NULL);
commit;
end;
/


