set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7525070';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3102231',
      NULL,
      3,
      1,
      0.157149,
      3,
      5.247471,
      33,
      58.828205,
      1.885992,
      NULL,
      NULL,
      2,
      0.882168,
      1,
      1.853447,
      0,
      1.060958,
      1,
      0.415451,
      1,
      0,
      1,
      0.154767,
      0,
      1.263025,
      NULL,
      1,
      0.794822,
      1,
      3,
      NULL,
      NULL,
      0,
      0.096003,
      1,
      0,
      1.860172,
      1.152001,
      0.279193,
      0,
      3,
      0.266503,
      NULL,
      1.481307,
      0,
      2.675287,
      1,
      0.110908,
      1.538374,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1.388973,
      1.738071,
      3,
      NULL,
      0.792238,
      1,
      0,
      NULL,
      NULL,
      0,
      1.870402,
      1.113382,
      1.639648,
      1.662932,
      0.516794,
      0,
      NULL,
      0.612903,
      0.513483,
      0,
      0,
      NULL,
      1,
      NULL,
      1.725859,
      NULL,
      NULL,
      1.325342,
      0,
      NULL,
      0.207009,
      0.940478,
      1,
      1.644497,
      NULL,
      3.493750,
      1.792826,
      NULL,
      0,
      0,
      0.404482,
      0,
      0.328403,
      2.162809,
      2.876106,
      1,
      3.010404,
      2,
      0.045179,
      13,
      NULL,
      '',
      NULL,
      ' 7-12-1990');
commit;
end;
/


