set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9127905';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2114010',
      1.041269,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      56,
      0,
      1,
      1,
      NULL,
      3.753806,
      0.415099,
      0.365171,
      2.641547,
      NULL,
      1.161401,
      0.794017,
      1,
      NULL,
      0.803419,
      0.674674,
      2.492975,
      1.153391,
      NULL,
      3,
      0,
      3.455278,
      1.542259,
      NULL,
      3.312191,
      1.689729,
      NULL,
      NULL,
      0.458269,
      0,
      0.907198,
      0,
      NULL,
      0,
      3,
      1,
      3,
      0.265987,
      NULL,
      0.352164,
      1,
      0,
      2,
      0.954998,
      1,
      1,
      0,
      2,
      1,
      0,
      3.746995,
      3.161115,
      2.707221,
      0,
      0.127277,
      3.679008,
      NULL,
      3.593092,
      2,
      3.368247,
      1,
      1.095452,
      NULL,
      1,
      1.495376,
      1,
      NULL,
      NULL,
      3.777741,
      1.446174,
      1.826717,
      0.187656,
      NULL,
      NULL,
      0.802314,
      NULL,
      1,
      0.827044,
      0.031643,
      3.692326,
      0,
      NULL,
      1,
      0,
      0,
      2.754375,
      NULL,
      0.319581,
      3.469992,
      0,
      3,
      NULL,
      1,
      1.028328,
      1,
      3,
      0,
      13,
      7,
      '313',
      '430',
      '10- 6-1988');
commit;
end;
/


