set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8618219';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4342340',
      3.285561,
      0,
      20,
      2,
      2,
      5.493353,
      NULL,
      47,
      1.663081,
      2.184172,
      2,
      0,
      1,
      1.702831,
      0.244003,
      0.847906,
      0,
      0,
      1,
      1,
      1,
      2.922190,
      1.138763,
      0.092894,
      0,
      NULL,
      0.024734,
      0.593159,
      1,
      0.652300,
      0,
      0.412660,
      1,
      1,
      1.915939,
      1.585199,
      1.510919,
      0,
      1,
      2.298081,
      0,
      3,
      2.896837,
      2,
      1,
      0,
      0.935797,
      NULL,
      NULL,
      3,
      1,
      1,
      0,
      1.021747,
      NULL,
      1,
      0.067673,
      1,
      0,
      2,
      NULL,
      1,
      1,
      0.312923,
      0.707226,
      NULL,
      0,
      3,
      0,
      1,
      1,
      1.050681,
      2.306553,
      NULL,
      1,
      3,
      0,
      1.126225,
      0,
      1,
      1,
      1.318602,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0.950895,
      1.173692,
      1.330878,
      NULL,
      1.651280,
      2,
      NULL,
      3,
      NULL,
      1.610014,
      3,
      0,
      NULL,
      1,
      3,
      NULL,
      '',
      ' 7-23-1984');
commit;
end;
/


