set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6800356';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1224410',
      NULL,
      NULL,
      3.931788,
      NULL,
      2.463021,
      NULL,
      10,
      29,
      1.847673,
      3,
      1.127098,
      3.669501,
      3.964214,
      0,
      0.518348,
      1,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      3.530797,
      1.779265,
      3.253087,
      1.960012,
      0.334693,
      0,
      0,
      NULL,
      1,
      0.894559,
      1.575133,
      0.276196,
      NULL,
      0.235404,
      0,
      NULL,
      NULL,
      3,
      2.434881,
      NULL,
      0,
      0.817274,
      2,
      0,
      1,
      0,
      2.033426,
      0,
      0,
      1.989136,
      1.294014,
      NULL,
      0.970342,
      NULL,
      1.617969,
      2.220550,
      0.095409,
      1,
      0.815303,
      1,
      1.636866,
      1,
      NULL,
      1,
      NULL,
      0.911825,
      0.844310,
      0.781622,
      0.360169,
      0,
      NULL,
      0.439605,
      1,
      0,
      NULL,
      0.412077,
      0.745541,
      1,
      NULL,
      0,
      NULL,
      1.476052,
      1,
      1.211288,
      0,
      1,
      1,
      NULL,
      0.595019,
      3.306927,
      NULL,
      0,
      1,
      1,
      NULL,
      2,
      1,
      1,
      NULL,
      NULL,
      1.824811,
      7.030746,
      NULL,
      '',
      '',
      ' 2-21-1996');
commit;
end;
/


