set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000221';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2314144',
      1.170501,
      3,
      33,
      3.941937,
      0,
      0.477639,
      58,
      108,
      1.703017,
      3,
      NULL,
      0,
      NULL,
      3.233895,
      1,
      NULL,
      0,
      1.431396,
      NULL,
      0.123214,
      0,
      0.439249,
      1.121454,
      0,
      1,
      2,
      2,
      NULL,
      2,
      0.931772,
      1.642554,
      0,
      NULL,
      1.376562,
      0.293796,
      0,
      NULL,
      2.191120,
      NULL,
      2.558315,
      NULL,
      1.254634,
      0.743547,
      3,
      1,
      1,
      3.026186,
      0,
      NULL,
      3.747056,
      1.216349,
      NULL,
      NULL,
      1,
      0.442109,
      2,
      1.364744,
      NULL,
      3.043491,
      0.761463,
      0.020997,
      1,
      0.047732,
      1,
      0.483731,
      1,
      NULL,
      0,
      3,
      1,
      1,
      0,
      1.767524,
      NULL,
      1,
      0,
      0.259762,
      1.274601,
      0.464700,
      2.334086,
      1,
      1,
      NULL,
      1,
      3,
      NULL,
      NULL,
      0,
      1.641422,
      3.193145,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.531042,
      0.099649,
      2,
      1.071801,
      2.091326,
      1,
      0,
      1,
      20,
      NULL,
      '033',
      '331',
      ' 4-22-1993');
commit;
end;
/


