set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000180';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4431143',
      1.556432,
      0,
      NULL,
      1,
      2.557129,
      2,
      3,
      67,
      NULL,
      2.417774,
      1,
      2.890114,
      1,
      0.893274,
      2.860457,
      NULL,
      1.961858,
      NULL,
      NULL,
      NULL,
      0,
      0.407024,
      1.158888,
      0.360668,
      1.988089,
      NULL,
      1,
      1.292432,
      2.161401,
      1.593519,
      0,
      0.841653,
      0.064762,
      1.299950,
      1,
      1,
      NULL,
      0,
      0.087167,
      3,
      1.525859,
      1.664910,
      0,
      3.404384,
      0.939069,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      0.258229,
      2.877932,
      0.910517,
      2.475738,
      0.818467,
      NULL,
      NULL,
      0.245601,
      1,
      3,
      0.038846,
      1,
      1,
      1,
      0.463116,
      1,
      NULL,
      NULL,
      1.476566,
      0.467870,
      1.230192,
      0,
      1,
      0.865658,
      0,
      0,
      0.491553,
      0,
      0.696150,
      1,
      0.545385,
      1,
      0,
      0.077368,
      NULL,
      NULL,
      2,
      0,
      1,
      NULL,
      NULL,
      2.767403,
      1.386279,
      NULL,
      0,
      0.641748,
      0,
      1.721486,
      11.398644,
      5,
      '',
      NULL,
      ' 9-25-1976');
commit;
end;
/


