set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9433307';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2140444',
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      63,
      NULL,
      1.984453,
      0,
      1.087928,
      1.433426,
      0,
      2.593875,
      2.200156,
      0,
      0.753449,
      3.501792,
      1,
      1,
      2.865117,
      NULL,
      3,
      1.288344,
      1,
      0,
      0,
      NULL,
      1.396784,
      1.490589,
      0,
      NULL,
      0.724772,
      1.124853,
      NULL,
      0.636259,
      1.124108,
      1,
      NULL,
      NULL,
      0.680027,
      0,
      NULL,
      0.115134,
      0,
      0,
      NULL,
      0.664003,
      0.605473,
      NULL,
      0.350383,
      1.436594,
      2,
      1.981952,
      0,
      1,
      NULL,
      3,
      1,
      0.529742,
      NULL,
      0,
      1.919410,
      1,
      2,
      0,
      NULL,
      NULL,
      2.528849,
      NULL,
      0.815079,
      1.490581,
      0.327306,
      0.433009,
      3.230704,
      1.608606,
      1,
      NULL,
      NULL,
      0.377860,
      1,
      1.565152,
      0,
      1,
      0,
      0.987240,
      1.151375,
      1.895120,
      1.264132,
      0,
      NULL,
      3.192099,
      0,
      NULL,
      1.179474,
      NULL,
      3,
      0,
      0,
      1.428010,
      2.921555,
      0,
      1,
      28.167521,
      0.640617,
      '130',
      '32',
      ' 2- 5-1991');
commit;
end;
/


