set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8212287';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      0,
      NULL,
      34.377378,
      2.670916,
      2,
      NULL,
      4.961613,
      21.046364,
      0.058811,
      3.712235,
      2,
      1,
      1.415301,
      1.956599,
      0.788654,
      NULL,
      1,
      0,
      1,
      0,
      0.106105,
      NULL,
      0.799688,
      1.021820,
      1,
      0,
      0,
      0,
      0,
      1,
      0,
      3,
      NULL,
      0,
      1.518647,
      3,
      0,
      1.483159,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      1,
      3.714805,
      3.448947,
      0.572433,
      NULL,
      NULL,
      0.661531,
      3.842790,
      0,
      1.868557,
      NULL,
      1,
      3.056716,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.291958,
      0,
      1.274995,
      3,
      1,
      0.919580,
      1.130895,
      NULL,
      1.527606,
      1.742111,
      0,
      1,
      3.830107,
      1.324038,
      NULL,
      NULL,
      0,
      0.138107,
      0.935237,
      1.867494,
      0,
      1.822909,
      NULL,
      0,
      1,
      0,
      3,
      1.276005,
      1.839128,
      1,
      2,
      2,
      0,
      0.504360,
      0.696704,
      2,
      1.077986,
      3.933632,
      1,
      3.940691,
      1,
      1.998865,
      5,
      '',
      NULL,
      '11-12-1982');
commit;
end;
/


