set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9023826';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1400132',
      NULL,
      0,
      14,
      2,
      0,
      NULL,
      NULL,
      40,
      0.625016,
      0.992725,
      0.631414,
      1,
      NULL,
      0.772280,
      0,
      2.302395,
      0.474513,
      0.530364,
      NULL,
      0.963050,
      1.751139,
      NULL,
      NULL,
      NULL,
      1,
      0.818046,
      0,
      1.243063,
      0,
      NULL,
      0.028359,
      0.566362,
      0.456082,
      0.050255,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3.858145,
      0,
      NULL,
      2,
      0,
      0,
      0.776325,
      1.278038,
      1.113152,
      NULL,
      1.096612,
      NULL,
      0,
      1,
      1.421979,
      1.105850,
      1,
      NULL,
      0.591041,
      1,
      0.875177,
      1,
      NULL,
      NULL,
      0.323691,
      NULL,
      3,
      1,
      1,
      1,
      NULL,
      0.721101,
      1.665138,
      1,
      2,
      1.925767,
      1,
      1.775443,
      1.926585,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.380449,
      1.053510,
      1.371016,
      0.079546,
      NULL,
      0,
      1.819764,
      1,
      NULL,
      3.144041,
      2,
      0,
      1.752328,
      0.964455,
      3,
      NULL,
      0,
      0.253122,
      0.446499,
      NULL,
      3,
      12.063823,
      3,
      '',
      '',
      NULL);
commit;
end;
/


