set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6310997';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4443302',
      3.117289,
      NULL,
      11,
      0,
      0.223285,
      NULL,
      NULL,
      31,
      NULL,
      0,
      0.621070,
      NULL,
      0.619134,
      0,
      NULL,
      1.941211,
      NULL,
      0.880343,
      NULL,
      0.564472,
      0.590274,
      3,
      1.925170,
      0,
      1.408019,
      3.684601,
      NULL,
      NULL,
      0.659391,
      NULL,
      0,
      NULL,
      0.511074,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      3,
      2,
      3,
      2,
      0,
      1.192483,
      1.194926,
      0.582134,
      0,
      NULL,
      0.886721,
      0.839872,
      0.076367,
      1,
      1.498157,
      NULL,
      1.339204,
      NULL,
      0.845648,
      0,
      NULL,
      NULL,
      1.456206,
      0.079358,
      1,
      NULL,
      2.283966,
      0,
      3.914269,
      1.030539,
      0.307838,
      NULL,
      1,
      NULL,
      NULL,
      1,
      3,
      0,
      1,
      1.807268,
      NULL,
      NULL,
      1.451470,
      0.275273,
      0.909069,
      0.345322,
      0.452168,
      NULL,
      0,
      0.904397,
      0.763535,
      NULL,
      0,
      1.060157,
      1,
      0,
      0,
      2.122767,
      0.766906,
      2.276789,
      3,
      1.232057,
      1,
      NULL,
      0.773409,
      NULL,
      0,
      '',
      NULL,
      ' 0-25-1996');
commit;
end;
/


