set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8831502';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3244033',
      NULL,
      0,
      25,
      5.728352,
      1.480586,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1.767120,
      2,
      2.660476,
      1.001132,
      1.877036,
      3.197558,
      NULL,
      1.980619,
      0.096578,
      NULL,
      0,
      1,
      0.778040,
      2.217451,
      0,
      3.579294,
      1.087944,
      0.873497,
      1.113903,
      3.093856,
      1.353807,
      0.454422,
      1.203032,
      NULL,
      0.336794,
      0,
      0.861825,
      1,
      0,
      1.923606,
      NULL,
      3.756235,
      1,
      2.463700,
      0,
      NULL,
      0,
      3.641190,
      NULL,
      2.335335,
      1.877170,
      0.396364,
      1.148072,
      NULL,
      0.709898,
      0.894004,
      1,
      1.598809,
      1,
      0,
      0.981560,
      1,
      1.635478,
      1,
      0.413094,
      3.348609,
      1.882944,
      2,
      0,
      0.280588,
      1,
      1,
      0,
      2,
      0.090378,
      0.951415,
      1,
      0.816040,
      1,
      1.773422,
      1.850330,
      0,
      0.627755,
      1,
      0,
      0.120060,
      0.721842,
      1,
      0,
      1.009439,
      NULL,
      0.641297,
      0,
      1.460000,
      0,
      1.681743,
      3.292438,
      1,
      NULL,
      3.727524,
      2.212661,
      0.809389,
      NULL,
      0,
      0,
      NULL,
      '000',
      '12',
      ' 4-23-1999');
commit;
end;
/


