set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8325901';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1414013',
      3.785532,
      1,
      1.605769,
      3,
      NULL,
      1.723527,
      32.624291,
      36,
      NULL,
      NULL,
      0.887786,
      3,
      1,
      0.629804,
      0.668645,
      0.497296,
      1,
      0,
      NULL,
      1.444028,
      1.572501,
      2,
      NULL,
      0.683020,
      0.925034,
      1.402656,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      1,
      1.121361,
      0.029342,
      3.063887,
      0.028827,
      1,
      0,
      NULL,
      NULL,
      2.114794,
      0.928338,
      2,
      1,
      NULL,
      1,
      0,
      1.442527,
      1,
      NULL,
      1,
      1.904806,
      1,
      1.820807,
      0.848362,
      NULL,
      NULL,
      0,
      1.979775,
      0,
      NULL,
      1,
      NULL,
      1,
      1,
      3,
      2.450269,
      0.677719,
      NULL,
      0,
      0,
      0.679781,
      0,
      0.255551,
      0,
      NULL,
      1.034606,
      1.326829,
      1,
      3,
      1.718999,
      NULL,
      1,
      1,
      0.369465,
      0,
      0.993508,
      3.492213,
      1.766431,
      3.170835,
      1.313856,
      0,
      1.365708,
      0,
      1,
      1.710332,
      1,
      1.751001,
      NULL,
      2,
      1,
      NULL,
      1,
      16,
      6.674065,
      '',
      '',
      ' 3-16-2002');
commit;
end;
/


