set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '5705774';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0121221',
      0,
      3,
      2.275680,
      3,
      0,
      NULL,
      NULL,
      37,
      1.964829,
      NULL,
      3.771016,
      NULL,
      NULL,
      1.724043,
      0,
      1,
      0.557571,
      0.158094,
      0,
      1,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      3,
      NULL,
      NULL,
      0,
      0,
      1,
      2,
      1,
      NULL,
      0,
      0,
      3,
      2.635299,
      0,
      3.830984,
      1.656852,
      1.108071,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      1.989065,
      0,
      0,
      1.772372,
      1.011422,
      0.668103,
      2.753853,
      3.823883,
      1.597310,
      1.511317,
      1,
      0.065854,
      1,
      2,
      0,
      1.411590,
      NULL,
      0.215722,
      NULL,
      0,
      2,
      3,
      1.320379,
      0.362132,
      1.385651,
      NULL,
      1,
      1.550901,
      NULL,
      0.885781,
      0,
      NULL,
      0,
      1,
      1,
      1.182964,
      NULL,
      NULL,
      0.402524,
      0.662232,
      0,
      1.913175,
      NULL,
      1.655714,
      1.367615,
      0.396238,
      NULL,
      0,
      0.642185,
      2,
      0,
      1.830298,
      8.096164,
      NULL,
      '',
      '',
      ' 5-24-1985');
commit;
end;
/


