set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8901750';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0421222',
      1,
      0,
      NULL,
      0.658595,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0.761201,
      0.127743,
      2,
      0,
      1.667308,
      3.673389,
      NULL,
      0,
      3,
      1,
      NULL,
      NULL,
      0,
      0.226870,
      0.039232,
      NULL,
      1.781895,
      1,
      1.826085,
      NULL,
      0.678416,
      1,
      1,
      0.541321,
      NULL,
      0.442091,
      1.258948,
      0,
      1.743193,
      1,
      1.777885,
      1.079988,
      1.783430,
      2,
      1.489927,
      2.809355,
      0.491886,
      0,
      0,
      1,
      0,
      1.387079,
      0,
      0,
      1,
      NULL,
      1.420017,
      1.901039,
      1.409541,
      2,
      1.180892,
      1,
      NULL,
      0.494881,
      1,
      3,
      1.644881,
      1.139789,
      0,
      NULL,
      1,
      NULL,
      1.108267,
      1,
      0.322000,
      NULL,
      1,
      NULL,
      1,
      0.547696,
      NULL,
      0,
      0.003709,
      0,
      0.873466,
      1,
      3.048324,
      1.784904,
      NULL,
      0,
      0.933622,
      2,
      2.463834,
      0.774888,
      NULL,
      0,
      0.449274,
      0.972466,
      NULL,
      NULL,
      3.124159,
      NULL,
      1.666373,
      1.464728,
      5,
      5,
      '',
      '',
      NULL);
commit;
end;
/


