set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000197';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      1,
      8,
      2.915993,
      2.444478,
      1,
      62.043851,
      49,
      1.428295,
      0.393583,
      0.757123,
      NULL,
      1.301361,
      1.735751,
      1,
      NULL,
      0,
      1,
      1.055814,
      0.619383,
      1.982607,
      3.779772,
      NULL,
      0.482427,
      0,
      1.959979,
      0.861125,
      0.432546,
      1.345081,
      2,
      1.942781,
      1.759717,
      1.454538,
      0.010312,
      0.496987,
      3,
      NULL,
      0.398953,
      0.248368,
      2.362477,
      NULL,
      0.042074,
      0.678677,
      3.043295,
      NULL,
      NULL,
      NULL,
      0,
      1.182835,
      NULL,
      1,
      0,
      NULL,
      0,
      1.512519,
      1.978256,
      NULL,
      0,
      1.503729,
      2.533038,
      1,
      1,
      0.148663,
      0.419567,
      0.019837,
      NULL,
      NULL,
      2,
      1,
      NULL,
      1.768845,
      1,
      NULL,
      3,
      1.631882,
      0.661649,
      1.755047,
      0,
      0.298173,
      0.574328,
      NULL,
      1,
      0.244913,
      NULL,
      1.531171,
      0.203740,
      1.493330,
      0.297747,
      1.660290,
      1.256589,
      1.654973,
      0.951582,
      2,
      1,
      0,
      1,
      0,
      2.069888,
      NULL,
      3.506543,
      NULL,
      NULL,
      3.059819,
      1.180825,
      11,
      NULL,
      NULL,
      '',
      ' 1-11-1986');
commit;
end;
/


