set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7434612';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4132102',
      0.730213,
      3,
      NULL,
      0.951833,
      NULL,
      NULL,
      NULL,
      30,
      0,
      NULL,
      3,
      1.577583,
      1.528749,
      0.205733,
      1,
      NULL,
      NULL,
      0.911230,
      NULL,
      1,
      1.426909,
      0,
      0,
      NULL,
      1,
      0,
      1.312793,
      0,
      0,
      1,
      1.805805,
      NULL,
      0.542563,
      1.059226,
      1,
      3.791086,
      0.305859,
      1,
      NULL,
      0.688552,
      3,
      2,
      3.225796,
      NULL,
      0.675450,
      1,
      1.576842,
      1.212541,
      1,
      NULL,
      1.731148,
      0.298650,
      1.538448,
      NULL,
      NULL,
      3,
      0,
      1.175719,
      3,
      NULL,
      0,
      0,
      1,
      0.586947,
      0.999956,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.663739,
      NULL,
      3.048228,
      NULL,
      1.513889,
      1.171023,
      0,
      0.490620,
      1,
      1.854787,
      1.913915,
      0.356407,
      1,
      1.853269,
      1.859205,
      0.456581,
      0,
      0,
      0.264986,
      0,
      1.404369,
      NULL,
      0,
      0.823943,
      0.748752,
      1,
      1,
      0.661188,
      3,
      1.902780,
      2,
      0.146139,
      0,
      3,
      2,
      '422',
      '230',
      ' 1-14-1998');
commit;
end;
/


