set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000187';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1130143',
      1.442986,
      0,
      17,
      3.611539,
      1,
      1,
      13.182848,
      NULL,
      0.826161,
      1,
      NULL,
      2.864414,
      2,
      0.006889,
      1,
      0,
      1.996622,
      1,
      2.322774,
      0.836946,
      1.139064,
      0.270597,
      NULL,
      0,
      1.001611,
      3,
      1.139295,
      1,
      0.729078,
      0.021223,
      0.107892,
      3,
      0,
      1.874576,
      0,
      3.863029,
      0,
      0.856485,
      0,
      0,
      1,
      3,
      NULL,
      3.102476,
      0.747740,
      NULL,
      1.228468,
      3,
      1.933306,
      1.990183,
      0,
      0,
      0,
      NULL,
      1,
      0.914514,
      0,
      0.731040,
      1.646270,
      3,
      1,
      0,
      NULL,
      0.823518,
      0.573452,
      NULL,
      1.907526,
      2.837228,
      1.440275,
      1,
      NULL,
      NULL,
      3.720641,
      0,
      0,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      1,
      0,
      0.932483,
      1,
      NULL,
      3.707866,
      0,
      0.947194,
      NULL,
      0.124174,
      0,
      0.799384,
      1,
      0,
      0,
      0.044694,
      0.145029,
      1.730003,
      1,
      1,
      NULL,
      0.156579,
      1.722096,
      5,
      2,
      '',
      '',
      '11- 2-1986');
commit;
end;
/


