set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000263';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      2.514190,
      0,
      25.513860,
      NULL,
      0.972395,
      2,
      30.175611,
      28.880577,
      1,
      1.550515,
      0.469651,
      3,
      2,
      0.442222,
      2.517432,
      2.853780,
      0,
      1,
      3.607790,
      0.912186,
      0.701902,
      1,
      NULL,
      0,
      0,
      2,
      1.978587,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.959500,
      1.141596,
      0.445806,
      0.696066,
      NULL,
      NULL,
      1.640824,
      NULL,
      1,
      0,
      3.052804,
      2.038056,
      0.211173,
      2.611268,
      0.893159,
      1.871690,
      0,
      1.366464,
      0.546030,
      1.387449,
      NULL,
      0,
      1.646099,
      NULL,
      0.358005,
      0,
      0.315656,
      NULL,
      1.314393,
      NULL,
      0,
      0,
      0,
      3.408085,
      0,
      NULL,
      0.060164,
      0,
      0.904623,
      0,
      0,
      3.221136,
      0.261657,
      1.201689,
      NULL,
      0.782812,
      NULL,
      1.271162,
      NULL,
      0,
      1.903179,
      1,
      1.435794,
      0,
      0,
      1.269768,
      0.424099,
      1,
      NULL,
      0.356341,
      3.783545,
      0,
      0.084827,
      1,
      NULL,
      NULL,
      1,
      0.865051,
      3.722455,
      0.741290,
      2.695131,
      1.423627,
      2.813211,
      2,
      '324',
      '200',
      ' 0- 1-1982');
commit;
end;
/


