set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8829625';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0222314',
      0.405650,
      NULL,
      27,
      NULL,
      1.961158,
      0.820137,
      NULL,
      25.679405,
      1,
      NULL,
      2,
      1.981415,
      0.763628,
      0,
      NULL,
      NULL,
      1,
      2,
      1.791420,
      1.922404,
      1.568499,
      NULL,
      1.457932,
      NULL,
      0,
      2.949829,
      NULL,
      NULL,
      1.405909,
      2,
      0,
      3.601365,
      0.458472,
      0.422358,
      0,
      3,
      1,
      NULL,
      0,
      1.739951,
      3,
      1,
      NULL,
      0.124941,
      1,
      NULL,
      0,
      3,
      NULL,
      3.473413,
      NULL,
      1,
      0.449392,
      1.563275,
      NULL,
      NULL,
      0.727290,
      0.053563,
      0.753372,
      1,
      1,
      0.328591,
      NULL,
      0,
      NULL,
      2,
      0.107300,
      0.886889,
      1,
      3.437760,
      1.174764,
      3,
      1,
      2,
      1,
      3,
      1,
      3.586722,
      NULL,
      NULL,
      1,
      1.420148,
      NULL,
      NULL,
      NULL,
      NULL,
      0.601294,
      2.491574,
      1.185955,
      0.757071,
      1,
      1.216657,
      3.142692,
      1.565392,
      0.636976,
      0.471488,
      0.042301,
      0.526520,
      0,
      3.318199,
      1.298938,
      0.450112,
      0.081322,
      2,
      19.982714,
      4.153370,
      '',
      '',
      NULL);
commit;
end;
/


