set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7608500';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0302402',
      NULL,
      NULL,
      16,
      NULL,
      0,
      5.343641,
      NULL,
      3,
      NULL,
      NULL,
      3.613692,
      3,
      2,
      1,
      1.284184,
      3,
      1,
      1,
      NULL,
      NULL,
      1.843203,
      3,
      NULL,
      0.414512,
      NULL,
      0.168721,
      0.461334,
      1,
      1.706828,
      3,
      1.880470,
      0,
      1.662739,
      0,
      1,
      0.166213,
      1,
      0.477643,
      0,
      3.437385,
      0,
      1.595777,
      NULL,
      1,
      1,
      1,
      NULL,
      0,
      0.312536,
      0.550410,
      NULL,
      1.705647,
      NULL,
      NULL,
      1.643252,
      1.461230,
      0.265447,
      2,
      NULL,
      0,
      1,
      NULL,
      1.552355,
      0,
      0,
      0,
      0.415195,
      NULL,
      0.662189,
      0.643962,
      0,
      0.126338,
      3,
      3.991680,
      0.610171,
      NULL,
      1,
      0.118502,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.807166,
      NULL,
      0,
      0.579738,
      0,
      1.083695,
      NULL,
      0,
      1,
      3,
      NULL,
      NULL,
      1.327477,
      3,
      1.815602,
      2,
      3.373201,
      1,
      NULL,
      NULL,
      1,
      4,
      2,
      '',
      '',
      ' 6-10-1992');
commit;
end;
/


