set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6111740';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1404322',
      3,
      1,
      35,
      2,
      1.170577,
      NULL,
      NULL,
      20.877557,
      0.574798,
      1,
      2,
      0.867500,
      0,
      0.601760,
      NULL,
      0.965675,
      1,
      0,
      0,
      1.163064,
      1,
      0.369179,
      0,
      2.495051,
      1.169453,
      0,
      0,
      1.293659,
      1,
      1,
      NULL,
      0.300733,
      1.789866,
      1,
      NULL,
      2,
      0.627470,
      1,
      0.545420,
      NULL,
      3.820678,
      1.674475,
      NULL,
      3.710574,
      0,
      0,
      0.700871,
      1,
      0.308120,
      NULL,
      1.684151,
      0,
      0,
      NULL,
      1.079910,
      1,
      0.241990,
      0.862158,
      2,
      1,
      1.062559,
      0,
      1.311072,
      0.755910,
      NULL,
      3.722037,
      0,
      0,
      NULL,
      1,
      0.573660,
      0.143613,
      3,
      1.639876,
      0,
      3.668930,
      0.953711,
      1,
      0,
      1,
      0,
      1.994321,
      1,
      1,
      0,
      0,
      0,
      1.773788,
      1,
      1.086199,
      2.402493,
      3,
      1,
      1,
      1.060218,
      1.994764,
      NULL,
      0.205699,
      NULL,
      3,
      NULL,
      0,
      NULL,
      0,
      5.943967,
      3.421392,
      '301',
      '444',
      NULL);
commit;
end;
/


