set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8924209';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1432340',
      0,
      0,
      22.957990,
      0.120483,
      1,
      NULL,
      NULL,
      85.210291,
      NULL,
      NULL,
      2.129001,
      0.335641,
      2,
      1.408776,
      1.992340,
      1.762125,
      1,
      1,
      1,
      3.492218,
      1,
      1.828677,
      NULL,
      NULL,
      1,
      0,
      0.517433,
      0,
      2,
      0.960909,
      1,
      1,
      1,
      0.273559,
      1.941946,
      NULL,
      0,
      0.329436,
      3,
      2.198146,
      1.704955,
      0,
      1.077674,
      3.743609,
      1.517119,
      3,
      NULL,
      3.180219,
      0.884917,
      2.834780,
      NULL,
      0,
      NULL,
      0.313278,
      0.146957,
      0.884795,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      0.159165,
      1,
      0.539087,
      0,
      1,
      1.376223,
      1,
      0.444689,
      NULL,
      0,
      1,
      1.070584,
      NULL,
      1,
      0.873974,
      0,
      0,
      1,
      1.467200,
      0,
      NULL,
      1,
      NULL,
      1.432745,
      0.034823,
      0,
      2.447371,
      1.557752,
      0.693646,
      0.106342,
      1.723031,
      1,
      1.898976,
      0.966665,
      2.646112,
      1.490484,
      1.017202,
      1,
      2,
      2,
      NULL,
      1.839233,
      9.834602,
      9,
      NULL,
      NULL,
      NULL);
commit;
end;
/


