set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '5907249';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      3,
      NULL,
      1.359260,
      0,
      NULL,
      NULL,
      12,
      0.868799,
      0.932816,
      3,
      3.545524,
      2,
      0,
      3.629916,
      NULL,
      1,
      1.363830,
      1.778590,
      1,
      1,
      2,
      0,
      3,
      1,
      1,
      0,
      NULL,
      0.718011,
      3,
      NULL,
      1.502643,
      1.352039,
      0,
      0.614603,
      0.420455,
      0,
      0,
      1.715075,
      0.520941,
      1.483788,
      NULL,
      3,
      3,
      1.289874,
      0.874364,
      0.523052,
      1,
      1.619312,
      1,
      NULL,
      0.950784,
      0.837806,
      NULL,
      0,
      0.530846,
      1.264224,
      3.813937,
      1.320953,
      NULL,
      0.396396,
      0,
      1,
      0.105416,
      1.372784,
      NULL,
      0.686354,
      0.261566,
      0.971505,
      1,
      1.893060,
      1.169564,
      NULL,
      1,
      1,
      2,
      1,
      1,
      1.555720,
      NULL,
      1.369042,
      0,
      0.795212,
      NULL,
      NULL,
      0.824266,
      NULL,
      0.129505,
      0.882980,
      0,
      0.536212,
      1.139833,
      NULL,
      0.851963,
      0,
      0,
      NULL,
      0,
      3,
      2,
      NULL,
      NULL,
      0,
      1,
      10.378985,
      3.380252,
      NULL,
      '',
      NULL);
commit;
end;
/


