set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9003604';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2331203',
      2.274697,
      2,
      13,
      1.658169,
      1.849795,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0.684417,
      1,
      2,
      NULL,
      NULL,
      0,
      1.237371,
      0,
      2.488050,
      0,
      1.493220,
      NULL,
      0.755657,
      3.121392,
      NULL,
      1,
      NULL,
      0.220598,
      0,
      0.543724,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      1.726020,
      NULL,
      0.769384,
      1,
      0.630626,
      1,
      0,
      1.040889,
      1.934831,
      0,
      1.720744,
      1.590879,
      NULL,
      NULL,
      3.442579,
      1.710804,
      1.411083,
      1,
      0.064365,
      1.493783,
      2,
      0.151572,
      1,
      1,
      0.763642,
      1.644090,
      1.222929,
      2,
      2.182944,
      1.050333,
      0,
      1,
      1.724259,
      1,
      0.968145,
      3.409683,
      1.372869,
      NULL,
      0,
      1,
      2.624907,
      0.100385,
      0.774272,
      0.939712,
      0,
      1.922556,
      0.422882,
      1.742729,
      0.178636,
      3.551919,
      0.782633,
      3.885261,
      NULL,
      2,
      0.192380,
      3.474713,
      1,
      1.411978,
      0.440754,
      4.564506,
      2,
      '',
      NULL,
      '10-26-1985');
commit;
end;
/


