set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000024';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1104120',
      2.169991,
      1,
      NULL,
      2.111632,
      3,
      4.108143,
      6.879934,
      NULL,
      1.893478,
      NULL,
      2,
      1,
      0,
      2.014254,
      NULL,
      0.789939,
      1.347479,
      0.521292,
      1,
      2,
      0.748282,
      NULL,
      0,
      0,
      0,
      2,
      0.511373,
      1.289125,
      NULL,
      0,
      1,
      1,
      1,
      0,
      0.705615,
      3,
      0.343399,
      1,
      NULL,
      0.946187,
      3,
      2.798020,
      2,
      3.932666,
      1.178946,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.687182,
      1.366133,
      1,
      NULL,
      1,
      2.144723,
      1.740561,
      0.772615,
      2.470359,
      1.737112,
      0,
      0.506572,
      1.647707,
      NULL,
      1,
      0,
      2,
      1.259040,
      1.084591,
      1,
      1.464287,
      1.815083,
      NULL,
      0,
      NULL,
      NULL,
      1.585134,
      1.429207,
      1,
      0,
      0,
      0.751079,
      1.809407,
      NULL,
      1.241200,
      1.975073,
      2.803982,
      1.153277,
      1,
      1.303395,
      0.510684,
      NULL,
      3.498978,
      NULL,
      NULL,
      1,
      2.115063,
      0,
      2,
      2,
      NULL,
      1,
      NULL,
      1,
      NULL,
      3,
      '',
      '',
      ' 4-19-1988');
commit;
end;
/


