set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7420791';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      1.577601,
      1,
      34,
      3.131141,
      0.173584,
      NULL,
      NULL,
      29.791715,
      NULL,
      NULL,
      3.586198,
      0.098412,
      0,
      1,
      NULL,
      1,
      0.489348,
      1,
      0.325958,
      0,
      0.485624,
      3,
      NULL,
      1.704139,
      NULL,
      NULL,
      0,
      1.916280,
      1.020845,
      2.935933,
      1.777472,
      1.514972,
      0.301957,
      1.732028,
      NULL,
      NULL,
      0.463830,
      1,
      0.748855,
      0.564122,
      3.954529,
      NULL,
      3.022706,
      2,
      NULL,
      2.187689,
      0.316022,
      0,
      NULL,
      NULL,
      NULL,
      1.323418,
      1,
      0,
      1,
      1,
      1,
      1,
      2.267840,
      3,
      1.257303,
      1.353410,
      0,
      1,
      1.751327,
      0.365727,
      0.114018,
      0.640706,
      1,
      0.408490,
      1.799691,
      NULL,
      0,
      3,
      1,
      0,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.365735,
      1,
      0.365950,
      1,
      NULL,
      0.523998,
      2.986346,
      3.678705,
      1.329413,
      0.631486,
      0.566096,
      2,
      0.561235,
      NULL,
      1.208661,
      0,
      NULL,
      0,
      0,
      NULL,
      2,
      '',
      NULL,
      ' 2-11-1985');
commit;
end;
/


