set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9221532';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1414402',
      1,
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      40,
      0.621102,
      2.120232,
      1,
      NULL,
      1,
      0,
      3.297238,
      2,
      0,
      1,
      3,
      0.135929,
      1.682669,
      2.719993,
      NULL,
      3,
      1,
      3,
      0,
      0.415253,
      0,
      0.118128,
      0.524096,
      1,
      NULL,
      1.366037,
      1,
      2.996105,
      1.672955,
      1,
      0,
      3.065983,
      0.180000,
      0,
      NULL,
      0.486639,
      0,
      3.791384,
      0.059576,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      1.958555,
      1,
      3,
      NULL,
      0,
      3,
      1,
      1.295018,
      0.976714,
      0.248100,
      1.953954,
      0,
      1.604182,
      1.590962,
      NULL,
      1.032552,
      0.515587,
      1,
      NULL,
      NULL,
      2,
      1.789800,
      1,
      1,
      0,
      NULL,
      1.045689,
      1.840056,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.684309,
      1.278733,
      1.248699,
      NULL,
      NULL,
      2.495490,
      0,
      NULL,
      1.026417,
      0,
      NULL,
      3.563564,
      0.057675,
      0.471719,
      0.964687,
      0,
      NULL,
      4.509619,
      0,
      '244',
      '200',
      ' 1-16-1988');
commit;
end;
/


