set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8904329';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3420304',
      2.611376,
      3,
      35.857455,
      NULL,
      2.790151,
      NULL,
      7,
      NULL,
      0.153859,
      3,
      0.834652,
      2,
      NULL,
      1,
      2.209854,
      NULL,
      NULL,
      0,
      3,
      NULL,
      0.213481,
      1.610399,
      0.070493,
      0,
      NULL,
      0,
      NULL,
      0.650293,
      1,
      0,
      0.813908,
      0.310404,
      2.761157,
      0.124598,
      NULL,
      2.986954,
      NULL,
      2.165812,
      0.863607,
      1.930253,
      3.669446,
      0.960451,
      0.004992,
      2,
      NULL,
      3.533208,
      0.773967,
      3,
      NULL,
      3.845863,
      1,
      1.462757,
      2.232639,
      1,
      0,
      0.843657,
      NULL,
      NULL,
      3.813663,
      0,
      NULL,
      1.314011,
      1.323578,
      2.079819,
      NULL,
      NULL,
      NULL,
      0.582671,
      0.799986,
      1,
      NULL,
      1.356508,
      1.310427,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.517543,
      1,
      1,
      NULL,
      0.401322,
      0,
      NULL,
      0.687025,
      0.885194,
      NULL,
      2.043525,
      NULL,
      1,
      1,
      0.636163,
      NULL,
      1.606782,
      0,
      1,
      NULL,
      0,
      2,
      1,
      2.540643,
      21.622911,
      NULL,
      '',
      ' 5-15-1998');
commit;
end;
/


