set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8103026';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3112414',
      1.374718,
      1,
      5,
      2.123156,
      0,
      2,
      2.867458,
      32.611222,
      3.097627,
      2.961133,
      1.727143,
      1,
      3,
      0,
      0.915632,
      0.399151,
      NULL,
      1.622286,
      0.824881,
      1.000966,
      1,
      3.149803,
      1.212286,
      1,
      1.359787,
      NULL,
      0.237396,
      NULL,
      0.770723,
      0,
      NULL,
      2,
      1.306022,
      3.427170,
      0,
      1,
      1,
      0,
      NULL,
      1.489127,
      0,
      2,
      NULL,
      1,
      3.319827,
      NULL,
      0.643571,
      0.578393,
      0.519030,
      0,
      0.668165,
      0.001447,
      1,
      3.833258,
      3.910459,
      0.894140,
      0,
      0,
      3,
      2,
      NULL,
      1,
      3.343709,
      3,
      0,
      1,
      3.840725,
      NULL,
      NULL,
      NULL,
      0.671366,
      NULL,
      3,
      0.225852,
      NULL,
      3,
      1.434895,
      2,
      0.621880,
      0.937481,
      1.168910,
      0,
      2,
      3.095408,
      0,
      1,
      1,
      3.489513,
      1.644912,
      0.013428,
      NULL,
      3.759409,
      2.253793,
      1.670867,
      0,
      0.073046,
      3.096117,
      NULL,
      1,
      0.698710,
      NULL,
      NULL,
      0.663044,
      1,
      35,
      18,
      '',
      '',
      NULL);
commit;
end;
/


