set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6916210';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1240343',
      0,
      0,
      9.791982,
      NULL,
      0.954096,
      NULL,
      NULL,
      40,
      1.288268,
      0.901853,
      0,
      2,
      2.917975,
      0,
      1,
      0,
      1,
      NULL,
      1.115333,
      0.995341,
      0,
      0.790716,
      0,
      1,
      0.585732,
      NULL,
      1,
      0,
      0.111336,
      2,
      NULL,
      NULL,
      0.839823,
      1,
      0,
      0,
      0,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      1.111147,
      1.432001,
      3,
      1,
      0,
      1.571816,
      3,
      0.658954,
      1.723527,
      NULL,
      1,
      0.039190,
      NULL,
      NULL,
      1,
      NULL,
      3,
      0.212080,
      1,
      0.096240,
      NULL,
      0,
      1.092570,
      0.786719,
      2,
      0.956159,
      1.911776,
      1,
      1.329672,
      3,
      0,
      0.112674,
      2.457793,
      0.538720,
      1,
      0.505258,
      1.935130,
      0.269528,
      1,
      1,
      0,
      1,
      0,
      NULL,
      0,
      1,
      0,
      0.196150,
      NULL,
      0,
      1,
      0,
      0.428987,
      NULL,
      1,
      2.915600,
      NULL,
      1.737887,
      3.350597,
      0,
      NULL,
      NULL,
      1,
      NULL,
      '',
      ' 0- 5-1996');
commit;
end;
/


