set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9422880';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4130204',
      NULL,
      1,
      NULL,
      5,
      0.563237,
      NULL,
      NULL,
      57,
      0.532482,
      2,
      1.466741,
      3,
      1.666578,
      3.569581,
      NULL,
      2,
      1.324044,
      0.860527,
      0.360295,
      0,
      0.983071,
      0.541496,
      0,
      1,
      NULL,
      0.555666,
      NULL,
      0,
      1,
      0.266350,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.029455,
      0,
      1,
      1.499533,
      0,
      3.621774,
      2.888258,
      0,
      3.453787,
      0.251299,
      2,
      1,
      NULL,
      1.668524,
      2,
      0.008693,
      1,
      1,
      0,
      NULL,
      NULL,
      0,
      1,
      1.380257,
      2.234235,
      0.847179,
      1.904282,
      0,
      1,
      0.830279,
      1.658041,
      0.285266,
      0,
      1.041499,
      NULL,
      NULL,
      1.565237,
      NULL,
      1.023119,
      0.743927,
      2,
      1.216042,
      0,
      1,
      2.110599,
      NULL,
      0.946771,
      1.034996,
      0.658172,
      1.353470,
      1,
      1,
      0,
      0.069751,
      1,
      1.466737,
      1.401017,
      3,
      0,
      NULL,
      0,
      0,
      2,
      3.072114,
      NULL,
      0,
      1,
      2.699213,
      1,
      NULL,
      2,
      NULL,
      '42',
      NULL);
commit;
end;
/


