set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000237';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1220440',
      0,
      3,
      24,
      1,
      3.513025,
      NULL,
      50,
      NULL,
      NULL,
      0.617037,
      NULL,
      2.452242,
      1.314690,
      0,
      2,
      2.465374,
      0,
      0,
      NULL,
      1.407439,
      1,
      3.959926,
      1.639720,
      NULL,
      0,
      0.450849,
      0,
      0,
      0.416124,
      2.738185,
      0,
      1.631549,
      1,
      1.628179,
      1.512511,
      0.711844,
      1,
      1,
      1.803913,
      3,
      1.809732,
      1,
      3,
      1.691126,
      0,
      1.410579,
      0,
      0,
      1.837423,
      0,
      1,
      0.839538,
      0,
      1.941760,
      NULL,
      0.161419,
      1.493674,
      NULL,
      2.636055,
      1.971256,
      0.649016,
      0.255106,
      1,
      0,
      1.935366,
      1,
      0,
      NULL,
      0.181269,
      NULL,
      1.676160,
      0,
      1,
      2,
      1,
      0.972566,
      NULL,
      NULL,
      0,
      NULL,
      1.419774,
      0.559889,
      0,
      1,
      0,
      0,
      1,
      0.824776,
      0,
      0,
      1,
      3.039545,
      NULL,
      NULL,
      0.494515,
      0,
      1.102889,
      1.914117,
      0,
      1.957567,
      NULL,
      2,
      2,
      0.492384,
      NULL,
      1.746318,
      '040',
      '004',
      ' 5-21-1976');
commit;
end;
/


