set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9224741';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      11.664848,
      NULL,
      NULL,
      NULL,
      NULL,
      17,
      NULL,
      0.042636,
      2.467851,
      NULL,
      1,
      1.568707,
      0.149767,
      1.255430,
      NULL,
      1.387902,
      1.889661,
      0.881205,
      3,
      3,
      NULL,
      1.142517,
      2,
      1.013776,
      1.003633,
      1,
      1,
      0.412090,
      0.312848,
      0,
      1,
      NULL,
      0,
      3,
      0,
      NULL,
      0.341741,
      NULL,
      0,
      3.250851,
      1,
      NULL,
      1.943579,
      2.738764,
      0,
      1.180973,
      1.838780,
      3,
      1.069962,
      1,
      NULL,
      1.727551,
      NULL,
      0.954198,
      1,
      2.241114,
      1.823761,
      1.558030,
      NULL,
      1.482150,
      0,
      1.257960,
      0.939577,
      3.496793,
      0.732579,
      2,
      1,
      0,
      1,
      1,
      2.849982,
      NULL,
      0,
      2.373452,
      0,
      0.134394,
      1.308216,
      0.656079,
      0,
      NULL,
      NULL,
      0.819229,
      1.364078,
      2,
      0.965147,
      0.166729,
      1,
      NULL,
      NULL,
      3.343344,
      2,
      0,
      0,
      1.027819,
      NULL,
      1,
      0,
      3.357279,
      3.325627,
      1,
      2.300856,
      NULL,
      1.231115,
      0.970106,
      '202',
      '044',
      ' 0-16-2003');
commit;
end;
/


