set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6809423';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4024233',
      3.131269,
      0,
      34,
      2,
      3,
      5.928403,
      48,
      67.908719,
      1,
      1,
      0.214814,
      0,
      1.932992,
      1,
      NULL,
      2,
      NULL,
      0.755896,
      0,
      3.687563,
      1.630319,
      1.265673,
      1,
      2,
      NULL,
      3,
      1,
      0,
      NULL,
      2,
      1.819698,
      0,
      NULL,
      1.176108,
      NULL,
      2,
      0,
      0.588100,
      1.136823,
      3.876772,
      2,
      0.471709,
      1.351545,
      1.610935,
      1,
      0,
      1.823412,
      1,
      0.827347,
      0,
      0.084384,
      1.595459,
      0.759051,
      0,
      0,
      0.487693,
      NULL,
      NULL,
      1.204971,
      0,
      1.296010,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      0,
      1,
      0,
      1.409688,
      1,
      1,
      0,
      3.197048,
      1.743213,
      1,
      1.198127,
      1.270637,
      0.094018,
      0,
      1.353187,
      NULL,
      1.726769,
      1,
      NULL,
      1.782823,
      0,
      1,
      NULL,
      1.969024,
      0,
      0.550915,
      0,
      NULL,
      2,
      0,
      0.286237,
      NULL,
      0,
      0,
      3,
      0.470473,
      NULL,
      3.151195,
      NULL,
      '',
      ' 9- 4-1993');
commit;
end;
/


