set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8901515';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2044240',
      NULL,
      NULL,
      NULL,
      NULL,
      1.000998,
      4.731123,
      NULL,
      1.896680,
      1.589799,
      2,
      2,
      3.153748,
      3.804707,
      0,
      1,
      1,
      0.793692,
      0.580969,
      NULL,
      1,
      0,
      1,
      NULL,
      1.878484,
      1.811186,
      0.004760,
      0.209851,
      1,
      0.060448,
      2.354993,
      1,
      NULL,
      1,
      1.215750,
      1,
      2.662638,
      1,
      0,
      1,
      2,
      1.055162,
      1,
      2.226247,
      2,
      1,
      NULL,
      1,
      0,
      NULL,
      2,
      NULL,
      1.160568,
      NULL,
      1.879982,
      1,
      0.529490,
      1,
      0,
      0.623611,
      2.813196,
      1.705859,
      0.065855,
      0.705537,
      1.938229,
      1.827818,
      1,
      1,
      0,
      0.171892,
      0,
      NULL,
      0.902678,
      NULL,
      2,
      0.002400,
      2,
      NULL,
      0,
      1.988072,
      NULL,
      1.523851,
      NULL,
      0,
      1.285162,
      NULL,
      1,
      0.787581,
      1.608877,
      0.698437,
      1.714498,
      NULL,
      0.494240,
      3.737718,
      1,
      1.477910,
      0.605602,
      1.142914,
      0,
      3.336487,
      NULL,
      1,
      NULL,
      1,
      1.938611,
      6.319859,
      1.866700,
      '',
      '',
      NULL);
commit;
end;
/


