set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6913619';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4330423',
      1,
      0,
      14.623163,
      2,
      2.967867,
      4,
      0,
      68.232759,
      1.647912,
      1,
      0.750351,
      3.190634,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.299510,
      0,
      0.556165,
      1.957347,
      0.827378,
      0.736314,
      0.317962,
      1,
      2,
      0.436603,
      0.027114,
      NULL,
      1.679531,
      NULL,
      0.162928,
      NULL,
      1,
      NULL,
      1.031567,
      1.330911,
      1.405124,
      0.135927,
      NULL,
      NULL,
      NULL,
      1.912783,
      3.778861,
      0.424195,
      2.161397,
      1,
      1,
      0.831330,
      NULL,
      1.641950,
      1.267158,
      0.452607,
      0.299294,
      NULL,
      1.197363,
      0,
      NULL,
      3.270868,
      0.348647,
      0,
      2.339464,
      1,
      1.688973,
      NULL,
      0.512665,
      0,
      1,
      0.636392,
      3.309736,
      1,
      0.214620,
      0.989923,
      0.025870,
      0,
      0,
      1,
      1,
      NULL,
      0,
      1,
      0,
      1.068901,
      0.832067,
      0.829268,
      0,
      NULL,
      0.087132,
      0,
      1.586473,
      0,
      NULL,
      3,
      1,
      1,
      NULL,
      0.161422,
      NULL,
      NULL,
      NULL,
      1.653221,
      NULL,
      0.726508,
      NULL,
      NULL,
      NULL,
      NULL,
      '',
      ' 5- 7-1975');
commit;
end;
/


