set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8902854';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1444334',
      2,
      1,
      NULL,
      2,
      NULL,
      3,
      3.677952,
      4,
      1,
      0.779506,
      0,
      NULL,
      NULL,
      0.539228,
      2.603595,
      NULL,
      0,
      NULL,
      2,
      2.866359,
      0,
      1,
      1,
      NULL,
      1.740509,
      0.576386,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.596686,
      0.958139,
      1.490089,
      0,
      3.022640,
      0.860200,
      1,
      0.507369,
      2,
      2,
      3,
      3.136061,
      2,
      0,
      1,
      0,
      3,
      1,
      2,
      NULL,
      0,
      0,
      NULL,
      0,
      1,
      1.393556,
      0,
      0.328295,
      NULL,
      1.649694,
      0,
      0.530040,
      1.999646,
      1.846520,
      0,
      1,
      0.866463,
      0.744739,
      1.350753,
      0,
      NULL,
      0.199679,
      1.858208,
      1,
      0,
      1.482259,
      0.513740,
      0.009740,
      NULL,
      NULL,
      1,
      1,
      1,
      1.090774,
      0,
      1,
      0,
      NULL,
      1.721433,
      1.038145,
      1.684828,
      0.165792,
      0.069229,
      1.408315,
      1,
      2,
      1.237640,
      1.942400,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      '',
      ' 6- 0-2001');
commit;
end;
/


