set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000227';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      1,
      2.449366,
      NULL,
      3,
      2.238850,
      8,
      22,
      1,
      NULL,
      0,
      0.694953,
      1,
      0.022556,
      0,
      3.348571,
      1,
      NULL,
      NULL,
      0.516393,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.396196,
      0,
      0.389965,
      1,
      1.599333,
      0.973418,
      3.466368,
      NULL,
      1,
      1,
      NULL,
      1,
      1.397394,
      NULL,
      0,
      0.571820,
      0,
      0.055001,
      0,
      3.574064,
      NULL,
      0,
      NULL,
      1.896109,
      NULL,
      NULL,
      1.222761,
      NULL,
      NULL,
      0,
      0.673584,
      0.645513,
      1.321610,
      1.431261,
      0.141121,
      0,
      1.988784,
      0,
      1.121571,
      0.250306,
      0,
      0.555020,
      1.790981,
      0.377539,
      1.715058,
      NULL,
      0.247542,
      NULL,
      3.752298,
      0.967334,
      3,
      1,
      1.732415,
      1.163199,
      NULL,
      2.579036,
      0,
      1,
      0,
      0,
      1.058567,
      1.580479,
      1,
      0.445386,
      0.118832,
      0,
      2,
      NULL,
      0,
      NULL,
      0,
      3.032014,
      0.006616,
      NULL,
      3,
      2,
      3,
      3.738782,
      1,
      NULL,
      NULL,
      '012',
      NULL,
      '11-23-1983');
commit;
end;
/


