set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7536053';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      0,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      53.582963,
      0,
      0,
      1.059049,
      NULL,
      NULL,
      0,
      3,
      0,
      1,
      1,
      NULL,
      1,
      1,
      2,
      NULL,
      1.996192,
      NULL,
      0,
      0.245307,
      0.999285,
      0,
      3,
      1,
      1,
      1.982832,
      0.509290,
      0,
      NULL,
      1.210277,
      NULL,
      1,
      NULL,
      1,
      3,
      3.825223,
      2.097994,
      0,
      0.914778,
      0.732029,
      1.855255,
      1,
      0.075490,
      1.304710,
      0.721071,
      NULL,
      0.977284,
      1.913541,
      1.747844,
      1.023573,
      NULL,
      3,
      0,
      0,
      1,
      1.268230,
      NULL,
      0,
      3.227693,
      0.078497,
      NULL,
      1.251952,
      0.262755,
      NULL,
      0.054255,
      NULL,
      1.509320,
      1.724032,
      2.042438,
      1.805999,
      0,
      NULL,
      1.555266,
      0,
      1.308059,
      NULL,
      1,
      0.236531,
      1.761531,
      0.795664,
      1.244999,
      0.119949,
      1,
      1,
      3,
      2,
      1.589693,
      0.361471,
      NULL,
      0,
      1.532799,
      3.968238,
      1,
      3.097088,
      1,
      0,
      1,
      0.568750,
      3.123066,
      '',
      '',
      ' 5-28-1976');
commit;
end;
/


