set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7838769';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0313221',
      NULL,
      2,
      23.527160,
      0.433962,
      1.588371,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.006261,
      3,
      3.383431,
      NULL,
      0,
      NULL,
      0.451114,
      3,
      1,
      0.413846,
      0.055303,
      0.560819,
      1.821318,
      2.411530,
      NULL,
      1.028744,
      0.947629,
      1.234309,
      1,
      2,
      0.159595,
      0.993991,
      1,
      1.421233,
      0,
      1,
      0,
      0.764386,
      0,
      1,
      3,
      2,
      3.465297,
      2,
      1.511671,
      2,
      0,
      1,
      NULL,
      1,
      1.514629,
      0.657761,
      0.372643,
      1.012618,
      NULL,
      0.832550,
      NULL,
      1,
      0.823890,
      NULL,
      1.808469,
      0,
      1,
      NULL,
      0.802802,
      3,
      1.909551,
      1,
      1.205223,
      NULL,
      0,
      1.458684,
      1.218561,
      3.748715,
      1,
      1.386274,
      NULL,
      NULL,
      NULL,
      0.436419,
      NULL,
      1.290401,
      1.764759,
      1.988427,
      1.513611,
      NULL,
      3.111343,
      0.438494,
      0.990896,
      NULL,
      1,
      3,
      NULL,
      0.057154,
      1.017800,
      NULL,
      NULL,
      NULL,
      2,
      3,
      0.207451,
      0,
      2.892349,
      1,
      1,
      NULL,
      '',
      NULL,
      ' 2-25-1974');
commit;
end;
/


