set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8702425';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4242144',
      NULL,
      NULL,
      12,
      1.045816,
      NULL,
      NULL,
      NULL,
      52,
      0.892802,
      3.241283,
      1.792735,
      NULL,
      1.473200,
      0,
      1.084786,
      1,
      1,
      0.956516,
      0.509749,
      NULL,
      0,
      2.577402,
      1,
      0.525738,
      NULL,
      NULL,
      0,
      0,
      NULL,
      3,
      0,
      1.202837,
      1.844943,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0.601530,
      1.624568,
      3,
      3,
      0.982131,
      3,
      0.561477,
      1.236695,
      1,
      3.847966,
      1.708802,
      0,
      0.243767,
      NULL,
      1,
      NULL,
      0,
      1,
      3.183300,
      0.412770,
      0.930849,
      0,
      0.210062,
      1.162621,
      1,
      3,
      0,
      1.560635,
      1.824124,
      0.259105,
      1,
      1.335363,
      1.282356,
      NULL,
      1.622808,
      0.712441,
      1,
      1,
      1.218465,
      0,
      0,
      1.460637,
      1,
      0.810184,
      1,
      NULL,
      NULL,
      0.953295,
      1.833303,
      1,
      0.846066,
      3,
      2,
      NULL,
      1,
      1,
      0,
      1.177606,
      1.080199,
      NULL,
      2.919506,
      2.837088,
      2.164769,
      0.310087,
      9.799126,
      1,
      '',
      NULL,
      ' 3- 3-1974');
commit;
end;
/


