set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6702935';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2234101',
      0.537380,
      0,
      19.621488,
      NULL,
      0.982947,
      4,
      49.267268,
      NULL,
      NULL,
      0.395873,
      NULL,
      3,
      0.270374,
      NULL,
      NULL,
      2,
      0,
      0,
      0.928624,
      NULL,
      1.726026,
      0,
      1.675188,
      3,
      1,
      1,
      0,
      1,
      1.959822,
      NULL,
      0.740493,
      1.030134,
      1,
      1,
      1.061063,
      1,
      1.050144,
      2,
      NULL,
      3,
      0.395961,
      0,
      3.892102,
      2.862304,
      1.251122,
      1.299145,
      NULL,
      NULL,
      NULL,
      0,
      0.516117,
      0.023293,
      NULL,
      NULL,
      1.768826,
      NULL,
      NULL,
      1.219968,
      3,
      3,
      0,
      0,
      0,
      NULL,
      0,
      3.532023,
      0.647941,
      2,
      1.893266,
      0.875395,
      NULL,
      0.529213,
      NULL,
      3.102207,
      1.837919,
      1,
      0,
      NULL,
      1,
      2,
      2,
      1,
      0,
      0.024662,
      1,
      0.331083,
      NULL,
      1.025161,
      0,
      0.412940,
      0.600371,
      2.495170,
      0.850943,
      1,
      1,
      0.674947,
      1.540091,
      0.406847,
      2,
      0,
      1.960996,
      2,
      NULL,
      1.828996,
      NULL,
      NULL,
      '403',
      NULL,
      ' 5-14-1984');
commit;
end;
/


